"""Various pytest utilities."""

from __future__ import unicode_literals


def register_pytest_funcarg(globals, name, testcase):
    """Registers a pytest funcarg for the specified TestCase.

    This allows to use unittest TestCases in pytest tests by calling:
    register_pytest_funcarg(globals(), "name", TestCase)
    """

    def fixture(request):
        test = testcase("setUp")
        test.setUp()
        request.addfinalizer(test.tearDown)
        return test

    globals["pytest_funcarg__" + name] = fixture
