from __future__ import print_function
from __future__ import unicode_literals

import json

from .common import add_parser


def build_service_runtime_attrs(args, repo_manager):
    if args.context:
        with open(args.context) as fd:
            context = json.load(fd)
    else:
        context = {}
    for service_id in args.service_id:
        repo_manager.build(service_id, context)
        print('build {}: success'.format(service_id))


def add_parsers(subparsers):
    get_parser = add_parser(subparsers, 'build', 'Render service', handler=build_service_runtime_attrs)
    get_parser.add_argument('service_id', nargs='+', help='Service ids', type=unicode)
    get_parser.add_argument('-c', '--context', help='Context in json format', type=unicode)
