from __future__ import print_function
from __future__ import unicode_literals

import service_repo_client.upload_v2_controller.storages as storages

from .common import add_parser


def get_service_v2(args, repo_manager):
    storages.GroupsStorage.init_client(args.staff_token)
    for service_id in args.service_id:
        storages.VaultSecretsStorage.update_signature(service_id)
        repo_manager.checkout_v2(service_id)
        print('get_v2 {}: success'.format(service_id))


def add_parsers(subparsers):
    get_parser = add_parser(subparsers, 'get_v2', 'Checkout service from service repository', handler=get_service_v2)
    get_parser.add_argument('service_id', nargs='+', help='Service ids', type=unicode)
    get_parser.add_argument('--staff-token', metavar='OAUTH_TOKEN',
                            help='Staff OAuth token (default: get from STAFF_TOKEN)')
