from __future__ import unicode_literals

import sys

from gevent.pool import Pool
from sepelib.gevent.utils import gevent_idle_iter
from service_repo_client.lib import progress_bar

from .common import add_parser


def _dump(repo_manager, service_id, pb):
    try:
        repo_manager.checkout(service_id, force=True, stdout=False, pretty=False)
    except Exception as e:
        print >> sys.stderr, '{} failed:\n{}'.format(service_id, e)
    pb.inc()


def async_dump(repo_manager, service_ids, pb, worker_count):
    pool = Pool(size=worker_count)
    for s_id in gevent_idle_iter(service_ids):
        pool.spawn(_dump, repo_manager, s_id, pb)
    pool.join(timeout=30)
    pool.kill()


def sync_dump(repo_manager, service_ids, pb):
    for s_id in service_ids:
        _dump(repo_manager, s_id, pb)


def dump_service(args, repo_manager):
    if args.all:
        service_ids = repo_manager.list()
    else:
        service_ids = args.service_id

    pb = progress_bar.ProgressBar(len(service_ids), args.progress)
    if args.worker > 1:
        async_dump(repo_manager, service_ids, pb, args.worker)
    else:
        sync_dump(repo_manager, service_ids, pb)


def add_parsers(subparsers):
    get_parser = add_parser(subparsers, 'dump', 'Dump service from service repository', handler=dump_service)
    get_parser.add_argument('service_id', nargs='*', help='Service ids', type=unicode)
    get_parser.add_argument('--all', action='store_true', help='Dump all services')
    get_parser.add_argument('-p', '--progress', action='store_true', help='Show progress')
    get_parser.add_argument('-w', '--worker', help='Worker count', type=int, default=1)
