from __future__ import print_function
from __future__ import unicode_literals

from .common import add_parser


def get_service(args, repo_manager):
    for service_id in args.service_id:
        repo_manager.checkout(service_id, args.force, args.stdout, args.pretty)
        if not args.stdout:
            print('get {}: success'.format(service_id))


def add_parsers(subparsers):
    get_parser = add_parser(subparsers, 'get', 'Checkout service from service repository', handler=get_service)
    get_parser.add_argument('service_id', nargs='+', help='Service ids', type=unicode)
    get_parser.add_argument('-f', '--force', action='store_true', help='Force get, rewriting changes')
    get_parser.add_argument('-s', '--stdout', action='store_true', help='Output to stdout, not files')
    get_parser.add_argument('-p', '--pretty', action='store_true', help='Pretty output to stdout')
