from __future__ import unicode_literals

import os
import pwd

from sepelib.core import config
from service_repo_client.lib.errors import AuthError
from .common import add_parser


def get_username():
    return pwd.getpwuid(os.getuid()).pw_name


def list_service(args, repo_manager):
    login = args.user or config.get_value('auth.login', default=None) or get_username()
    if not login:
        raise AuthError('User login is not given in -u/--user argument and is not present in config file')
    for service_id in repo_manager.list(login):
        print(service_id)


def add_parsers(subparsers):
    list_parser = add_parser(subparsers, 'list', 'List services', handler=list_service)
    list_parser.add_argument('-u', '--user', help='User login', type=unicode)
