from __future__ import unicode_literals

from .common import add_parser


def restore(args, repo_manager):
    for service_id in args.service_id:
        repo_manager.create(service_id, args.message)
        print('restore {}: success'.format(service_id))


def add_parsers(subparsers):
    get_parser = add_parser(subparsers, 'restore', 'Restore service (only if not exists)', handler=restore)
    get_parser.add_argument('service_id', nargs='+', help='Service ids', type=unicode)
    get_parser.add_argument('-m', '--message', help='Comment message',
                            default='Restore service from service-repo-client')
