from __future__ import print_function
from __future__ import unicode_literals

from .common import add_parser


def update_service(args, repo_manager):
    for service_id in args.service_id:
        repo_manager.update(service_id)
        print('update {}: success'.format(service_id))


def add_parsers(subparsers):
    update_parser = add_parser(subparsers,
                               'update',
                               'Checkout service from service repository, rewrite local if found newer version',
                               handler=update_service)
    update_parser.add_argument('service_id', nargs='+', help='Service ids', type=unicode)
