from __future__ import print_function
from __future__ import unicode_literals

from .common import add_parser


def upload(args, repo_manager):
    for service_id in args.service_id:
        repo_manager.upload(service_id, args.message)
        print('upload {}: success'.format(service_id))


def add_parsers(subparsers):
    get_parser = add_parser(subparsers, 'upload', 'Upload built service to service repo', handler=upload)
    get_parser.add_argument('service_id', nargs='+', help='Service ids', type=unicode)
    get_parser.add_argument('-m', '--message', help='Comment message',
                            default='New service content from service-repo-client')
