from __future__ import print_function
from __future__ import unicode_literals

import service_repo_client.upload_v2_controller.storages as storages
from .common import add_parser


def upload_v2(args, repo_manager):
    storages.SandboxResourcesStorage.init_client(args.sandbox_token)
    storages.VaultSecretsStorage.init_client(args.vault_token)
    storages.GroupsStorage.init_client(args.staff_token)
    for service_id in args.service_id:
        storages.VaultSecretsStorage.update_signature(service_id)
        repo_manager.upload_v2(service_id, args.message, args.scheduling_priority, not args.no_color, args.yes)
        print('upload_v2 {}: success'.format(service_id))


def add_parsers(subparsers):
    get_parser = add_parser(subparsers, 'upload_v2', 'Upload built service to service repo', handler=upload_v2)
    get_parser.add_argument('service_id', nargs='+', help='Service ids', type=unicode)
    get_parser.add_argument('-m', '--message', help='Comment message',
                            default='New service content from service-repo-client')
    get_parser.add_argument('-p', '--scheduling-priority', help='Scheduling priority for changes in runtime_attrs',
                            default='NONE', choices=('NONE', 'NORMAL', 'CRITICAL'))
    get_parser.add_argument('--no-color', help='Disable colors in diff', action='store_true')
    get_parser.add_argument('--yes', help='Skip additional confirmation', action='store_true')
    get_parser.add_argument('--sandbox-token', metavar='OAUTH_TOKEN',
                            help='Sandbox OAuth token (default: get from SANDBOX_OAUTH_TOKEN)')
    get_parser.add_argument('--vault-token', metavar='OAUTH_TOKEN',
                            help='Vault OAuth token (default: get from VAULT_TOKEN)')
    get_parser.add_argument('--staff-token', metavar='OAUTH_TOKEN',
                            help='Staff OAuth token (default: get from STAFF_TOKEN)')
