import json

from service_repo_client.lib.errors import InvalidContentError


class FileOperator(object):
    @classmethod
    def write(cls, path, content):
        """
        :type path: str | unicode
        :type content: str | unicode
        """
        if isinstance(content, unicode):
            content = content.encode('utf8')
        with open(path, 'w') as f:
            f.write(content)

    @classmethod
    def read(cls, path):
        """
        :type path: str | unicode
        :rtype: unicode
        """
        with open(path) as f:
            return f.read().decode('utf8')


class JsonFileOperator(FileOperator):
    @classmethod
    def write(cls, path, content):
        with open(path, 'w') as f:
            json.dump(content, f, indent=4, sort_keys=True)

    @classmethod
    def read(cls, path):
        with open(path) as f:
            try:
                return json.load(f)
            except ValueError as err:
                raise InvalidContentError('Could not parse {}:\n{}'.format(path, err.message))
