import google.protobuf.json_format as json_format


# Compatibility with protobuf>==3.0.0 and 3.0.0b
if hasattr(json_format, '_MessageToJsonObject'):
    def pb_to_jsondict(message):
        return json_format._MessageToJsonObject(message, True)
elif hasattr(json_format, 'MessageToJson'):
    def pb_to_jsondict(message):
        p = json_format._Printer(including_default_value_fields=True)
        return p._MessageToJsonObject(message)
else:
    raise Exception("Not compatible protobuf version!")

if hasattr(json_format, '_ConvertMessage'):
    jsondict_to_pb = json_format._ConvertMessage
elif hasattr(json_format, 'Parse'):
    def jsondict_to_pb(d, message):
        p = json_format._Parser(True, None)
        p.ConvertMessage(d, message)
else:
    raise Exception("Not compatible protobuf version!")
