import sys


class ProgressBar(object):
    def __init__(self, total, enabled=True):
        self.i = 0
        self.total = total
        self.enabled = enabled

    def inc(self):
        self.i += 1
        if self.enabled:
            self._draw()

    def _draw(self):
        percent = "{0:.1f}".format(100 * (self.i / float(self.total)))
        filled_length = int(100 * self.i // self.total)
        bar = '=' * filled_length + ' ' * (100 - filled_length)
        sys.stdout.write('\r')
        sys.stdout.write('|%s| %s%%' % (bar, percent))
        sys.stdout.flush()
        if self.i == self.total:
            sys.stdout.write('\n')
