from __future__ import unicode_literals

import os
import json

import jinja2
from sepelib.util.fs import makedirs_ignore


def _resource_dump(data):
    """
    :type data: dict
    :rtype: unicode
    """
    return ' ' * 12 + json.dumps(data)


def sandbox_file(task_type, task_id, resource_type):
    """
    :type task_type: str | unicode
    :type task_id: str | unicode
    :type resource_type: str | unicode
    :rtype: unicode
    """
    return _resource_dump({
        'task_type': unicode(task_type),
        'task_id': unicode(task_id),
        'resource_type': unicode(resource_type),
    })


def sandbox_shard(task_type, task_id, resource_type):
    """
    :type task_type: str | unicode
    :type task_id: str | unicode
    :type resource_type: str | unicode
    :rtype: unicode
    """
    return _resource_dump({
        'chosen_type': 'SANDBOX_SHARD',
        'task_type': unicode(task_type),
        'task_id': unicode(task_id),
        'resource_type': unicode(resource_type),
    })


def static_file(file_path):
    """
    :type file_path: str | unicode
    :rtype: unicode
    """
    return _resource_dump({'content': unicode(file_path)})


def url_file(url):
    """
    :type url: str | unicode
    :rtype: unicode
    """
    return _resource_dump({'url': unicode(url)})


def get_render_helper(service_id, rendered_resources_dir):
    """
    :type service_id: unicode
    :type rendered_resources_dir: unicode
    :rtype: collections.Callable
    """

    def render(file_path):
        makedirs_ignore(rendered_resources_dir)
        render_loader = jinja2.FileSystemLoader(searchpath='.')
        render_env = jinja2.Environment(loader=render_loader)
        render_template = render_env.get_template(file_path)
        result = render_template.render({'service_id': service_id})
        result_path = os.path.join(rendered_resources_dir, os.path.basename(file_path))
        with open(result_path, 'w') as fd:
            fd.write(result)
        return result_path

    return render
