import os

import jinja2

from service_repo_client.lib import render_helpers


class TemplateEnv(object):
    def __init__(self, service_id, service_path):
        self.service_id = service_id
        self.service_path = service_path

    def get_env(self):
        loader = jinja2.FileSystemLoader(searchpath=self.service_path)
        return jinja2.Environment(loader=loader)


class RuntimeAttrsEnv(TemplateEnv):
    def get_env(self):
        env = super(RuntimeAttrsEnv, self).get_env()
        env.globals['render'] = render_helpers.get_render_helper(
            self.service_id, os.path.join(self.service_path, 'rendered_resources')
        )
        env.globals['static_file'] = render_helpers.static_file
        env.globals['sandbox_file'] = render_helpers.sandbox_file
        env.globals['sandbox_shard'] = render_helpers.sandbox_shard
        env.globals['url_file'] = render_helpers.url_file
        return env
