import service_repo_client.upload_v2_controller.common as lib_common
import service_repo_client.upload_v2_controller.storages as lib_storages


class BaseAuthController(lib_common.BaseController):
    template_key = None
    state_key = None

    def load_state(self, state, working_dir):
        template = lib_common.load_template(working_dir, lib_common.AUTH_ATTRS)['content'].get(self.template_key, {})
        if not template:
            return

        state = state.setdefault('auth_attrs', {}).setdefault(self.state_key, {})
        if template.get('logins'):
            state['logins'] = template['logins']
        if template.get('groups'):
            groups_storage = lib_storages.GroupsStorage()
            state['groups'] = [groups_storage.get_url_by_id(group_id) for group_id in template['groups']]

    def apply_state(self, state, working_dir):
        state = state.get('auth_attrs', {}).get(self.state_key, {})

        template_part = {}
        if state:
            if state.get('logins'):
                template_part['logins'] = state['logins']
            if state.get('groups'):
                groups_storage = lib_storages.GroupsStorage()
                template_part['groups'] = [groups_storage.get_id_by_url(url) for url in state['groups']]

        template = lib_common.load_template(working_dir, lib_common.AUTH_ATTRS)
        template['content'][self.template_key] = template_part
        lib_common.dump_template(working_dir, lib_common.AUTH_ATTRS, template)


class OwnersController(BaseAuthController):
    template_key = 'owners'
    state_key = 'owners'


class ObserversController(BaseAuthController):
    template_key = 'observers'
    state_key = 'observers'


class ConfigurationManagersController(BaseAuthController):
    template_key = 'conf_managers'
    state_key = 'configuration_managers'


class OperationManagersController(BaseAuthController):
    template_key = 'ops_managers'
    state_key = 'operation_managers'
