#!/usr/bin/env python
from __future__ import unicode_literals

import time
import json
import logging
import logging.handlers
import argparse

import requests


HEADERS = {
    'Accept-Encoding': '',
    'Content-Type': 'application/json',
    'Accept': 'application/json'
}

HQS = [
    'hq.msk-swat.yandex-team.ru',
    'hq.sas-swat.yandex-team.ru',
    'hq.man-swat.yandex-team.ru',
    'hq.vla-swat.yandex-team.ru',
]


log = logging.getLogger('unseal')


def process_backend(backend, unseal_keys):

    r = requests.get('http://{}/v1/sys/health'.format(backend), headers=HEADERS)

    if not r.json()['sealed']:
        return

    log.critical('%s is sealed', backend)

    for k in unseal_keys:
        r = requests.post('http://{}/v1/sys/unseal'.format(backend), data=json.dumps({'key': k}), headers=HEADERS)
        log.critical('%s response: %s', backend, r.json())
        r.raise_for_status()


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('service')
    parser.add_argument('keys')
    parser.add_argument('delay', type=int)
    args = parser.parse_args()

    handler = logging.handlers.RotatingFileHandler('unseal.log', maxBytes=100 * 1024 ** 2, backupCount=10)
    formatter = logging.Formatter('%(asctime)s - %(lineno)d - %(process)d - %(message)s')
    handler.setFormatter(formatter)
    log = logging.getLogger('unseal')
    log.addHandler(handler)

    while True:
        for hq in HQS:

            with open(args.keys) as fd:
                keys = [i.strip() for i in fd]

            hq_url = 'https://{}/rpc/instances/FindInstances/'.format(hq.rstrip('/'))
            req = {
                "filter": {
                    "serviceId": args.service
                },
                "fieldMask": {
                    "paths": ["meta.id"]
                }
            }

            resp = requests.post(hq_url, data=json.dumps(req), headers=HEADERS)
            resp.raise_for_status()

            for i in resp.json()['instance']:
                instance = i['meta']['id']
                host_port, _ = instance.split('@', 1)
                try:
                    process_backend(host_port, keys)
                except Exception:
                    pass

            time.sleep(args.delay)
