#!/usr/bin/env python

import argparse
import sys

from gevent import monkey
from instancectl.config import config
from instancectl.lib.confutil import make_minidump_sender_from_config

monkey.patch_all()

from instancectl.jobs import helpers as job_helpers
from instancectl.lib import envutil


def register_args(parser):
    parser.add_argument(
        "-c", "--config", metavar="CONFIGFILE", dest="config",
        help="config file", type=str, default="loop.conf",
    )

    parser.add_argument(
        "--hq-url", metavar="HQ_URL", dest="hq_url",
        help="HQ URL", type=str, default=None
    )


def main(argv):
    def parse_args(argv):
        parser = argparse.ArgumentParser(add_help=True)

        register_args(parser)

        return parser.parse_args(argv)

    args = parse_args(argv)

    env = envutil.make_instance_ctl_env(args.hq_url)

    conf = config.get_or_compile_instance_config(args.config, env)

    for section, s in conf["jobs"].iteritems():
        limits = job_helpers.make_limits_dict_from_config(s)
        minidump_sender = make_minidump_sender_from_config(section, s, limits)
        minidump_sender.run()


if __name__ == "__main__":
    main(sys.argv[1:])
