import os

import nanny_rpc_client

from infra.nanny.yp_lite_api.proto import pod_sets_api_pb2
from infra.nanny.yp_lite_api.py_stubs import pod_sets_api_stub


if __name__ == '__main__':
    c = nanny_rpc_client.RetryingRpcClient(rpc_url='https://yp-lite-ui.nanny.yandex-team.ru/api/yplite/pod-sets/',
                                           oauth_token=os.getenv('OAUTH'))
    stub = pod_sets_api_stub.YpLiteUIPodSetsServiceStub(c)
    req = pod_sets_api_pb2.GetPodSetRequest()
    req.cluster = 'SAS'
    req.service_id = 'yp-test-alonger'
    print(stub.get_pod_set(req))
