package main

import (
	"a.yandex-team.ru/infra/nanny2/pkg/federated"
	"a.yandex-team.ru/infra/nanny2/pkg/federated/service"
	"a.yandex-team.ru/infra/nanny2/pkg/log"
	"flag"
	"gopkg.in/yaml.v2"
	"io/ioutil"
)

func main() {
	listener := flag.String("listener", ":8080", "listener, e.g. ':8080'")
	configPath := flag.String("config", "", "full path to config file")
	flag.Parse()
	if *configPath == "" {
		log.Error("Config must be passed via -config")
		return
	}
	config := &service.ClusterConfig{}
	data, err := ioutil.ReadFile(*configPath)
	if err != nil {
		log.Errorf("Failed to open config at %s", *configPath)
		return
	} else {
		e := yaml.Unmarshal(data, config)
		if e != nil {
			log.Errorf("Failed to parse config at %s", *configPath)
			return
		}
	}
	cfg := federated.Config{
		Listener:      *listener,
		ClusterConfig: config,
	}
	log.Error(federated.Main(cfg).Error())
}
