package main

import (
	"flag"
	"strings"
	"time"

	"a.yandex-team.ru/infra/nanny2/pkg/hq"
	"a.yandex-team.ru/infra/nanny2/pkg/log"

	"os"
)

const (
	envStaffToken = "HQ_STAFF_TOKEN"
)

func main() {
	listener := flag.String("listener", ":8080", "listener, e.g. ':8080'")
	etcdEndpoints := flag.String("etcd", "127.0.0.1:2379", "comma separated list of etcd endpoints")
	offlinePeriod := flag.Duration("offline_period", 10*time.Minute, "offline period (move instances to offline)")
	offlineStreak := flag.Int("offline_streak", 10, "max instances count to move to offline on each period")
	noAuth := flag.Bool("no_auth", false, "disable authentication/authorization")
	storageCodec := flag.String("storage_codec", "r-snappy", "how to encode-decode storage data, one of: r-snappy, rw-snappy")

	ypClusters := flag.String("yp_cluster", "", "fetch yp pods from clusters (coma separated)")
	fetchYpPodsBatchSize := flag.Int("fetch_yp_pods_batch_size", 200, "fetch yp pods batch size")

	flag.Parse()
	// Now grab some sensitive data from env
	token, _ := os.LookupEnv(envStaffToken)
	// Create config and run
	cfg := &hq.Config{
		Listener:             *listener,
		EtcdEndpoints:        strings.Split(*etcdEndpoints, ","),
		OfflinePeriod:        *offlinePeriod,
		OfflineStreak:        *offlineStreak,
		NoAuth:               *noAuth,
		StaffToken:           token,
		StorageCodec:         *storageCodec,
		FetchYpPodsBatchSize: int32(*fetchYpPodsBatchSize),
		YpClusters:           strings.Split(*ypClusters, ","),
	}
	log.Fatal(hq.Main(cfg).Error())
}
