package main

import (
	"context"
	"flag"
	"gopkg.in/yaml.v2"
	"io/ioutil"
	"log"
	"os"

	"a.yandex-team.ru/infra/nanny2/pkg/hqsyncer"
)

func main() {
	cfgFilename := flag.String("c", "cfg.yml", "config filename, e.g. 'cfg.yml'")
	dryRun := flag.Bool("dry-run", false, "just list pods w/o updating")
	flag.Parse()

	data, err := ioutil.ReadFile(*cfgFilename)
	if err != nil {
		log.Fatal(err.Error())
	}

	cfg := hqsyncer.Config{
		SleepAfterIterationSeconds: 5,
		FetchYpPodsBatchSize:       200,
		StrippedHQClusters:         make([]string, 0),
		StrippedHQServices:         make([]string, 0),
		CustomYpClusterSuffixes:    make(map[string]string),
		MaxPodsToUpdateOnIteration: 100,
	}

	err = yaml.Unmarshal(data, &cfg)
	if err != nil {
		log.Fatal(err.Error())
	}

	if cfg.RPCConfig.OauthToken == "" {
		cfg.RPCConfig.OauthToken = os.Getenv("HQ_API_TOKEN")
	}

	if len(cfg.YpClusters) == 0 {
		log.Fatal("yp_clusters must be given in config")
	}
	if cfg.LockeNodeYtPath == "" {
		log.Fatal("locke_node_yt_path must be given in config")
	}

	ctx := context.TODO() // ?

	log.Fatal(hqsyncer.Main(ctx, &cfg, *dryRun).Error())
}
