package api

import (
	pb "a.yandex-team.ru/yp/go/proto/hq"
	"github.com/golang/protobuf/proto"
)

var statusNotImplemented = &pb.Status{
	Status:  StatusFailure,
	Code:    StatusCodeNotImplemented,
	Reason:  StatusReasonNotImplemented,
	Message: "This functionality is not yet implemented",
}

// FailNotImplemented returns API response tuple to signal that particular functionality is not implemented.
func FailNotImplemented() (proto.Message, *pb.Status) {
	return nil, statusNotImplemented
}

// FailBadRequest returns API response tuple to signal that user request is not correct
func FailBadRequest(message string) (proto.Message, *pb.Status) {
	return nil, &pb.Status{
		Status:  StatusFailure,
		Reason:  StatusReasonBadRequest,
		Code:    StatusCodeBadRequest,
		Message: message,
	}
}

// FailNotFound returns API response tuple to signal that user requested entity has not been found
func FailNotFound(message string) (proto.Message, *pb.Status) {
	return nil, &pb.Status{
		Status:  StatusFailure,
		Reason:  StatusReasonNotFound,
		Code:    StatusCodeNotFound,
		Message: message,
	}
}

// FailInternalError returns API response tuple to signal that system failed
// to process request due to internal error
func FailInternalError(message string) (proto.Message, *pb.Status) {
	return nil, &pb.Status{
		Status:  StatusFailure,
		Code:    StatusCodeInternalError,
		Reason:  StatusReasonInternalError,
		Message: message,
	}
}

func IsNotFound(status *pb.Status) bool {
	return status.Code == StatusCodeNotFound
}

var StatusLimitExceeded = &pb.Status{
	Status:  StatusFailure,
	Reason:  StatusReasonServerBusy,
	Code:    StatusCodeServerBusy,
	Message: "Service is busy, try later",
}
