package api

import (
	"bytes"
	"net/http/httptest"
	"testing"

	"github.com/golang/protobuf/proto"

	pb "a.yandex-team.ru/yp/go/proto/hq"
)

func TestReadRequest(t *testing.T) {
	m := &pb.GetClusterRequest{}
	m.Name = "man_prod"
	buf, err := proto.Marshal(m)
	if err != nil {
		t.Fatalf("Failed to marshal: %s", err.Error())
	}
	m.Reset()
	req := httptest.NewRequest("POST", "/rpc/FindClusters/", bytes.NewBuffer(buf))
	req.Header.Set(headerContentType, headerValueProtobuf)
	status := ReadRequest(req, m)
	if status != nil {
		t.Errorf("ReadRequest() failed with %+v", status)
	}
	if m.Name != "man_prod" {
		t.Errorf("Deserialized message is invalid: %+v", m)
	}
}
