package api

import (
	"a.yandex-team.ru/infra/nanny2/pkg/log"
	pb "a.yandex-team.ru/yp/go/proto/hq"
	"github.com/golang/protobuf/jsonpb"
	"github.com/golang/protobuf/proto"
	"net/http"
)

var marshaller = jsonpb.Marshaler{EmitDefaults: true}

func writeResource(w http.ResponseWriter, r *http.Request, res proto.Message) {
	if r.Header.Get(headerAccept) == headerValueProtobuf {
		w.Header().Set(headerContentType, headerValueProtobuf)
		data, err := proto.Marshal(res)
		if err != nil {
			w.WriteHeader(StatusCodeInternalError)
			_, err = w.Write([]byte("Failed to deserialize response"))
			if err != nil {
				log.Errorf("Failed to write response: %s", err.Error())
			}
		} else {
			_, err = w.Write(data)
			if err != nil {
				log.Errorf("Failed to write response: %s", err.Error())
			}
		}
	} else {
		w.Header().Set(headerContentType, headerValueJSON)
		err := marshaller.Marshal(w, res)
		if err != nil {
			log.Errorf("Failed to write response: %s", err.Error())
		}
	}
}

func writeStatus(w http.ResponseWriter, r *http.Request, s *pb.Status) {
	if s.Code == 500 {
		log.Errorf("Failure on %s: %s", r.URL, s)
	}
	if r.Header.Get(headerAccept) == headerValueProtobuf {
		w.Header().Set(headerContentType, headerValueProtobuf)
		w.WriteHeader(int(s.Code))
		data, err := proto.Marshal(s)
		if err != nil {
			log.Errorf("Failed to write response: %s", err.Error())
			w.WriteHeader(StatusCodeInternalError)
			_, _ = w.Write([]byte("Failed to deserialize response"))
		} else {
			_, _ = w.Write(data)
		}
	} else {
		w.Header().Set(headerContentType, headerValueJSON)
		w.WriteHeader(int(s.Code))
		err := marshaller.Marshal(w, s)
		if err != nil {
			log.Errorf("Failed to write response: %s", err.Error())
			w.WriteHeader(StatusCodeInternalError)
			_, _ = w.Write([]byte("Failed to deserialize response"))
		}
	}
}

func WriteResponse(w http.ResponseWriter, r *http.Request, res proto.Message, status *pb.Status) {
	if status == nil || status.Status == StatusSuccess {
		writeResource(w, r, res)
	} else {
		writeStatus(w, r, status)
	}
}
