package api

import (
	pb "a.yandex-team.ru/yp/go/proto/hq"
	"bytes"
	"github.com/golang/protobuf/proto"
	"net/http/httptest"
	"testing"
)

func Test_writeResource(t *testing.T) {
	m := pb.GetClusterResponse{}
	m.Value = &pb.Cluster{
		Meta: &pb.ClusterMeta{
			Name: "man_prod",
		},
	}
	req := httptest.NewRequest("POST", "/rpc/GetCluster/", bytes.NewBuffer(nil))
	req.Header.Set(headerContentType, headerValueProtobuf)
	req.Header.Set(headerAccept, headerValueProtobuf)
	w := httptest.NewRecorder()
	writeResource(w, req, &m)
	if w.Code != 200 {
		t.Errorf("Invalid response code: %d", 200)
	}
	m.Reset()
	err := proto.Unmarshal(w.Body.Bytes(), &m)
	if err != nil {
		t.Fatalf("Failed to unmarshal response: %s", err.Error())
	}
	if h := w.Header().Get(headerContentType); h != headerValueProtobuf {
		t.Errorf("Invalid %s header value: %s != %s", headerContentType, h, headerValueProtobuf)
	}
}
