package concur

import (
	"testing"
)

func testPanic(t *testing.T, f func()) {
	defer func() {
		if r := recover(); r == nil {
			t.Error("The code did not panic")
		}
	}()
	f()
}

func TestNewCapacityLimiter(t *testing.T) {
	cl := NewCapacityLimiter(100)
	if cl.current != 0 {
		t.Fatalf("initial current: %d != 0", cl.current)
	}
	if cl.limit != 100 {
		t.Fatalf("limit(%d) != provided value (%d)", cl.current, 100)
	}
	testPanic(t, func() {
		NewCapacityLimiter(0)
	})
	testPanic(t, func() {
		NewCapacityLimiter(2 << 31)
	})
}

func TestCapLimiter_Add(t *testing.T) {
	cl := NewCapacityLimiter(1)
	if !cl.Add() {
		t.Fatal("Add failed, should not")
	}
	if cl.current != 1 {
		t.Fatalf("current(%d) != expected(%d)", cl.current, 1)
	}
	if cl.Add() {
		t.Fatal("Add succeeded, should not")
	}
	if cl.current != 1 {
		t.Fatalf("current(%d) != expected(%d)", cl.current, 1)
	}
	cl.Done()
	if cl.current != 0 {
		t.Fatalf("current(%d) != expected(%d)", cl.current, 0)
	}
}
