package federated

import (
	"a.yandex-team.ru/infra/nanny2/pkg/federated/service"
	"a.yandex-team.ru/infra/nanny2/pkg/log"
	"net/http"
	"time"
)

var (
	responseWriteTimeout = 60 * time.Second
	requestReadTimeout   = 10 * time.Second
)

type Config struct {
	Listener      string
	ClusterConfig *service.ClusterConfig
}

func Main(cfg Config) error {
	cStorage := &service.Storage{}
	cStorage.Init(cfg.ClusterConfig)
	// Setup and start controller
	// Setup HTTP router
	mux := service.NewRouter()
	// Setup API service
	// Register RPC services
	service.NewFederatedService(cStorage).Mount(mux)
	httpSrv := http.Server{
		Addr:         cfg.Listener,
		Handler:      mux,
		ReadTimeout:  requestReadTimeout,
		WriteTimeout: responseWriteTimeout,
	}
	// Run
	log.Infof("Hi, I am FederateD. And I am going to serve on %s", cfg.Listener)
	err := httpSrv.ListenAndServe()
	return err
}
