package service

import (
	"a.yandex-team.ru/infra/nanny2/pkg/middleware"
	"github.com/go-chi/chi/v5"
	"net/http"
	"net/http/pprof"
)

func attachProfiler(mux *chi.Mux) {
	mux.Get("/debug/pprof/", pprof.Index)
	mux.Get("/debug/pprof/{name}", pprof.Index)
}

func attachHeathCheck(mux *chi.Mux) {
	h := func(w http.ResponseWriter, r *http.Request) {
		w.WriteHeader(http.StatusOK)
		_, _ = w.Write([]byte("OK"))
	}
	mux.Get("/healthz", h)
	mux.Get("/ping", h)
}

func NewRouter() *chi.Mux {
	mux := chi.NewRouter()
	mux.Use(
		// Arbitrary chosen value just to be sure we have something against DoS
		middleware.InFlight(300),
		middleware.DebugHeaders,
		middleware.HandleCORS,
	)
	attachProfiler(mux)
	attachHeathCheck(mux)
	return mux
}
