package service

import (
	proto "a.yandex-team.ru/yp/go/proto/hq"
)

type ClusterInfo struct {
	Desc     string `yaml:"desc"`
	Endpoint string `yaml:"endpoint"`
}

type ClusterConfig struct {
	Clusters []map[string]ClusterInfo `yaml:"clusters"`
}

type Storage struct {
	clusters        map[string]*proto.Cluster
	orderedClusters []*proto.Cluster
}

type ClusterStorage interface {
	Init(cfg *ClusterConfig) error

	// Get cluster by name
	Get(key string) (cluster *proto.Cluster, err error)

	// List returns a slice of all clusters
	List() (clusters []*proto.Cluster, err error)
}

func (s *Storage) Init(cfg *ClusterConfig) {
	s.clusters = make(map[string]*proto.Cluster, len(cfg.Clusters))
	for _, cluster := range cfg.Clusters {
		for name, clusterInfo := range cluster {
			c := &proto.Cluster{
				Spec: &proto.ClusterSpec{
					Desc: clusterInfo.Desc,
					Endpoint: &proto.ClusterEndpoint{
						Url: clusterInfo.Endpoint,
					},
				},
				Meta: &proto.ClusterMeta{
					Name:       name,
					Version:    "7", // legacy compatibility
					Generation: 0,   // legacy compatibility
				},
			}
			s.clusters[name] = c
			s.orderedClusters = append(s.orderedClusters, c)
		}
	}
}

func (s *Storage) Get(key string) (cluster *proto.Cluster) {
	cluster, ok := s.clusters[key]
	if !ok {
		return nil
	}
	return cluster
}

func (s *Storage) List() (clusters []*proto.Cluster) {
	return s.orderedClusters
}
