package cache

import (
	"errors"

	proto "a.yandex-team.ru/yp/go/proto/hq"
)

type FindByServiceFunc func(serviceID string, readyOnly bool) ([]*proto.Instance, string)

// Stub to use in tests (implements InstanceIndex)
type FakeInstanceIndex struct {
	OnFindByService FindByServiceFunc
}

func (f *FakeInstanceIndex) LastIndex() string {
	return "0"
}

func (f *FakeInstanceIndex) InstanceCount() int {
	return 0
}

func (f *FakeInstanceIndex) FindByService(serviceID string, readyOnly bool) ([]*proto.Instance, string) {
	if f.OnFindByService != nil {
		return f.OnFindByService(serviceID, readyOnly)
	}
	return nil, "0"
}

func (f *FakeInstanceIndex) GetStatsByService(serviceID string) InstanceStats {
	return InstanceStats{ReadyCount: 0, TotalCount: 0}
}

func (f *FakeInstanceIndex) GetRevisionStats(serviceID string) RevisionStats {
	return RevisionStats{}
}

func (f *FakeInstanceIndex) ListAttributeValues(attr string) ([]string, error) {
	return nil, errors.New("not implemented")
}
