package housekeeping

import "testing"

// Simple test, that updating priority works
func TestExpirationQueue_UpdateValue(t *testing.T) {
	q := NewQueue()
	_, ok := q.Peak()
	if ok {
		t.Fatal(ok)
	}
	q.UpdateValue(expireValue{ID: "1"}, 1)
	v, ok := q.Peak()
	if !ok {
		t.Fatal(ok)
	}
	if v.value.ID != "1" || v.priority != 1 {
		t.Fatalf("%+v: %+v", v, q.pq)
	}
	q.UpdateValue(expireValue{ID: "1"}, 2)
	v, ok = q.Peak()
	if !ok {
		t.Fatal(ok)
	}
	if v.value.ID != "1" || v.priority != 2 {
		t.Fatalf("%+v: %+v", v, q.pq)
	}
}
