package service

import (
	"a.yandex-team.ru/infra/nanny2/pkg/hq/cache"
	"a.yandex-team.ru/infra/nanny2/pkg/middleware"
	"a.yandex-team.ru/infra/nanny2/pkg/storage"
	"a.yandex-team.ru/infra/nanny2/pkg/ypclient"
	pb "a.yandex-team.ru/yp/go/proto/hq"
	"context"
	"github.com/go-chi/chi/v5"
	"github.com/golang/protobuf/proto"
	"net/http"
	"net/http/pprof"
)

func attachProfiler(mux *chi.Mux) {
	mux.Get("/debug/pprof/profile", pprof.Profile)
	mux.Get("/debug/pprof/heap", pprof.Index)
	mux.Get("/debug/pprof/goroutine", pprof.Index)
}

func attachHeathCheck(mux *chi.Mux, iStore storage.Interface) {
	h := func(w http.ResponseWriter, r *http.Request) {
		err := iStore.Status(context.Background())
		if err != nil {
			w.WriteHeader(http.StatusBadGateway)
			return
		}
		w.WriteHeader(http.StatusOK)
		_, _ = w.Write([]byte("OK"))
	}
	mux.Get("/healthz", h)
	mux.Get("/ping", h)
}

// attachCatchAllOldInstanceService responds OK to all requests coming from old instancectl
func attachCatchAllOldInstanceService(mux *chi.Mux) {
	m := pb.Instance{}
	b, err := proto.Marshal(&m)
	if err != nil {
		panic(err)
	}
	mux.Post("/rpc/instance/{name}/", func(w http.ResponseWriter, r *http.Request) {
		w.WriteHeader(200)
		_, _ = w.Write(b)
	})
}

func NewRouter(iStore storage.Interface, idx cache.InstanceIndex, ypClient ypclient.YpClientInterface) *chi.Mux {
	mux := chi.NewRouter()
	mux.Use(
		middleware.InFlight(700),
		middleware.HandleCORS,
		middleware.DebugHeaders,
		middleware.Gzip,
	)
	attachProfiler(mux)
	attachHeathCheck(mux, iStore)
	attachCatchAllOldInstanceService(mux)
	// Register RPC servers
	NewInstanceRPCService(iStore, idx, ypClient).Mount(mux)
	return mux
}
