// Implementation of storage.ObjectCreator interface for HQ objects.
package storable

import (
	"a.yandex-team.ru/infra/nanny2/pkg/storage"
	proto "a.yandex-team.ru/yp/go/proto/hq"
)

type instanceCreator int

var InstanceCreator instanceCreator

func (c instanceCreator) New() storage.Storable {
	return &proto.Instance{}
}

func (c instanceCreator) Version(m interface{}) string {
	return m.(*proto.Instance).Meta.Version
}

func (c instanceCreator) SetVersion(raw interface{}, version string) {
	m := raw.(*proto.Instance)
	if m.Meta == nil {
		m.Meta = &proto.InstanceMeta{}
	}
	m.Meta.Version = version
}
