package validation

import (
	"net/http"
	"strings"
)

func getIPFromHeader(header http.Header) string {
	IPRaw := strings.SplitN(header.Get("X-Forwarded-For"), ", ", 2)
	if len(IPRaw) == 0 {
		return ""
	}
	return IPRaw[0]
}

func getOAuthTokenFromHeader(header http.Header) string {
	tokenHeader := header.Get("Authorization")
	if !strings.HasPrefix(tokenHeader, "OAuth ") {
		return ""
	}

	return strings.TrimPrefix(tokenHeader, "OAuth ")
}
