package validation

import (
	"github.com/stretchr/testify/assert"
	"net/http"
	"testing"
)

func TestIPFromHeader_OneIP(t *testing.T) {
	header := http.Header{
		"X-Forwarded-For": []string{"127.0.0.1"},
	}
	assert.Equal(t, "127.0.0.1", getIPFromHeader(header))
}

func TestIPFromHeader_TwoIPs(t *testing.T) {
	header := http.Header{
		"X-Forwarded-For": []string{"127.0.0.1, 192.168.0.1"},
	}
	assert.Equal(t, "127.0.0.1", getIPFromHeader(header))
}

func TestIPFromHeader_ThreeIPs(t *testing.T) {
	header := http.Header{
		"X-Forwarded-For": []string{"127.0.0.1, 192.168.0.1, 8.8.8.8"},
	}
	assert.Equal(t, "127.0.0.1", getIPFromHeader(header))
}

func TestOAuthFromHeader_Empty(t *testing.T) {
	header := http.Header{}
	assert.Equal(t, "", getOAuthTokenFromHeader(header))
}

func TestOAuthFromHeader_WithoutPrefix(t *testing.T) {
	header := http.Header{
		"Authorization": []string{"some_token"},
	}
	assert.Equal(t, "", getOAuthTokenFromHeader(header))
}

func TestOAuthFromHeader_WithPrefix(t *testing.T) {
	header := http.Header{
		"Authorization": []string{"OAuth some_token"},
	}
	assert.Equal(t, "some_token", getOAuthTokenFromHeader(header))
}
