package validation

import (
	"a.yandex-team.ru/library/go/yandex/blackbox"
	"a.yandex-team.ru/library/go/yandex/blackbox/httpbb"
	"context"
	"errors"
	"net/http"
)

var errOauthTokenIsInvalid = errors.New("OAuth token is invalid")
var errIPDiscoveryDoesNotWork = errors.New("can't determine user's ip")

func GetUsernameByToken(ctx context.Context, token string, userIP string) (string, error) {
	bb, err := httpbb.NewIntranet()
	if err != nil {
		return "", err
	}

	bbResponse, err := bb.OAuth(ctx, blackbox.OAuthRequest{
		OAuthToken: token,
		UserIP:     userIP,
	})

	if err != nil {
		return "", err
	}

	return bbResponse.User.Login, nil
}

var tokenStorage ValidOAuthTokenStorage

func ValidateOAuthToken(ctx context.Context, token string, userIP string, desiredLogin string) error {
	username, err := GetUsernameByToken(ctx, token, userIP)
	if err != nil {
		if tokenStorage.ValidateToken(token) {
			return nil
		}

		return err
	}

	if username != desiredLogin {
		return errOauthTokenIsInvalid
	}

	tokenStorage.SetValidToken(token)

	return nil
}

func ValidateUserAccess(ctx context.Context, header http.Header, desiredLogin string) error {
	if desiredLogin == "" {
		return nil
	}

	userIP := getIPFromHeader(header)
	if userIP == "" {
		return errIPDiscoveryDoesNotWork
	}

	token := getOAuthTokenFromHeader(header)
	if token == "" {
		return errOauthTokenIsInvalid
	}

	return ValidateOAuthToken(ctx, token, userIP, desiredLogin)
}
