package validation

import (
	"sync"
	"time"
)

type ValidOAuthTokenStorage struct {
	mutex     sync.Mutex
	token     string
	timestamp time.Time
	isSet     bool
}

func (s *ValidOAuthTokenStorage) SetValidToken(token string) {
	s.mutex.Lock()
	defer s.mutex.Unlock()

	s.token = token
	s.timestamp = time.Now()
	s.isSet = true
}

func (s *ValidOAuthTokenStorage) ValidateToken(token string) bool {
	s.mutex.Lock()
	defer s.mutex.Unlock()

	if !s.isSet {
		return false
	}

	if s.token != token {
		return false
	}

	if time.Since(s.timestamp) > time.Hour {
		return false
	}

	return true
}
