package hqsyncer

import (
	"fmt"

	"a.yandex-team.ru/infra/nanny2/pkg/rpc"
	pb "a.yandex-team.ru/yp/go/proto/hq"
)

type HQClient struct {
	strippedHQClusters, strippedHQServices []string
	customYpClusterSuffixes                map[string]string
	ClientFactory                          map[string]pb.InstanceServiceClient
}

func getRPCURL(cluster string) string {
	switch cluster {
	case "sas", "sas-test":
		return "https://hq.sas-swat.yandex-team.ru/rpc/instances"
	case "man", "man-pre":
		return "https://hq.man-swat.yandex-team.ru/rpc/instances"
	case "vla":
		return "https://hq.vla-swat.yandex-team.ru/rpc/instances"
	default:
		return "https://hq.msk-swat.yandex-team.ru/rpc/instances"
	}
}

func NewHQClient(strippedHQClusters, strippedHQServices, ypClusters []string, rpcConfig rpc.ClientConfig, customYpClusterSuffixes map[string]string) *HQClient {
	c := &HQClient{
		strippedHQClusters:      strippedHQClusters,
		strippedHQServices:      strippedHQServices,
		ClientFactory:           map[string]pb.InstanceServiceClient{},
		customYpClusterSuffixes: customYpClusterSuffixes,
	}
	for _, cluster := range ypClusters {
		rpcConfig.RPCURL = getRPCURL(cluster)
		c.ClientFactory[cluster] = pb.NewInstanceServiceClient(rpc.NewClient(&rpcConfig))
	}
	return c
}

func contains(arr []string, str string) bool {
	for _, s := range arr {
		if s == str {
			return true
		}
	}
	return false
}

func (c *HQClient) GetHQPodID(cluster, podID, serviceID string) string {
	if contains(c.strippedHQClusters, cluster) || contains(c.strippedHQServices, serviceID) {
		return fmt.Sprintf("%s@%s", podID, serviceID)
	}

	suffix := c.customYpClusterSuffixes[cluster]
	if suffix == "" {
		suffix = "yp-c.yandex.net"
	}
	return fmt.Sprintf("%s.%s.%s@%s", podID, cluster, suffix, serviceID)
}
