package hqsyncer

import (
	"testing"

	"a.yandex-team.ru/infra/nanny2/pkg/rpc"
	"github.com/stretchr/testify/assert"
)

func TestGetHQPodID(t *testing.T) {
	strippedHQClusters := append(make([]string, 0), "sas")
	strippedHQServices := append(make([]string, 0), "stripped")
	ypClusters := append(make([]string, 0), "sas", "sas-test")
	rpcConfig := rpc.ClientConfig{Retry429: true}
	customYpClusterSuffixes := map[string]string{"sas-test": "yp-test.yandex.net"}

	client := NewHQClient(strippedHQClusters, strippedHQServices, ypClusters, rpcConfig, customYpClusterSuffixes)

	assert.Equal(t, client.GetHQPodID("sas", "pod-1", "service"), "pod-1@service")
	assert.Equal(t, client.GetHQPodID("sas-test", "pod-1", "service"), "pod-1.sas-test.yp-test.yandex.net@service")
	assert.Equal(t, client.GetHQPodID("sas-test", "pod-1", "stripped"), "pod-1@stripped")
}
