package log

import (
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	zp "go.uber.org/zap"
	"go.uber.org/zap/zapcore"
)

var (
	logger = zap.Must(zp.Config{
		Level:            zp.NewAtomicLevelAt(zp.InfoLevel),
		Encoding:         "console",
		OutputPaths:      []string{"stdout"},
		ErrorOutputPaths: []string{"stderr"},
		EncoderConfig: zapcore.EncoderConfig{
			MessageKey:     "msg",
			LevelKey:       "level",
			TimeKey:        "ts",
			CallerKey:      "caller",
			EncodeLevel:    zapcore.CapitalLevelEncoder,
			EncodeTime:     zapcore.ISO8601TimeEncoder,
			EncodeDuration: zapcore.StringDurationEncoder,
			EncodeCaller:   zapcore.ShortCallerEncoder,
		},
	})
)

func Debug(msg string, fields ...log.Field) {
	logger.Debug(msg, fields...)
}

func Info(msg string, fields ...log.Field) {
	logger.Info(msg, fields...)
}

func Warn(msg string, fields ...log.Field) {
	logger.Warn(msg, fields...)
}

func Error(msg string, fields ...log.Field) {
	logger.Error(msg, fields...)
}

func Fatal(msg string, fields ...log.Field) {
	logger.Fatal(msg, fields...)
}

func Debugf(msg string, args ...interface{}) {
	logger.Debugf(msg, args...)
}

func Infof(msg string, args ...interface{}) {
	logger.Infof(msg, args...)
}

func Warnf(msg string, args ...interface{}) {
	logger.Warnf(msg, args...)
}

func Errorf(msg string, args ...interface{}) {
	logger.Errorf(msg, args...)
}

func Fatalf(msg string, args ...interface{}) {
	logger.Fatalf(msg, args...)
}
