package middleware

import "net/http"

func HandleCORS(next http.Handler) http.Handler {
	fn := func(w http.ResponseWriter, r *http.Request) {
		h := w.Header()
		h.Add("Access-Control-Allow-Credentials", "true")
		h.Add("Access-Control-Allow-Headers", "content-type,if-match,accept,x-req-id,x-rtc-client")
		h.Add("Access-Control-Allow-Methods", "POST")
		h.Add("Access-Control-Allow-Origin", "*")
		if r.Method == "OPTIONS" {
			return
		}
		next.ServeHTTP(w, r)
	}
	return http.HandlerFunc(fn)
}
