package middleware

import (
	"fmt"
	"net/http"
	"os"
)

var hostname string

func init() {
	h, err := os.Hostname()
	if err != nil {
		panic(fmt.Sprint("Failed to acquire host name ", err))
	}
	hostname = h
}

// DebugHeaders returns middleware which adds debug headers to server response.
// Namely:
//	* X-Backend-Host - host name of server
func DebugHeaders(next http.Handler) http.Handler {
	fn := func(w http.ResponseWriter, r *http.Request) {
		w.Header().Set("X-Backend-Host", hostname)
		next.ServeHTTP(w, r)
	}
	return http.HandlerFunc(fn)
}
