package middleware

import (
	"a.yandex-team.ru/infra/nanny2/pkg/concur"
	"net/http"
)

func InFlight(limit int) func(next http.Handler) http.Handler {
	cl := concur.NewCapacityLimiter(limit)
	fn := func(next http.Handler) http.Handler {
		fn := func(w http.ResponseWriter, r *http.Request) {
			if cl.Add() {
				defer cl.Done()
				next.ServeHTTP(w, r)
			}
		}
		return http.HandlerFunc(fn)
	}
	return fn
}
