package middleware

import (
	"a.yandex-team.ru/infra/nanny2/pkg/api"
	"golang.org/x/time/rate"
	"net/http"
)

type rateLimiter struct {
	limiter rate.Limiter
}

func (rl *rateLimiter) ServeHTTP(w http.ResponseWriter, r *http.Request, next http.HandlerFunc) {
	if rl.limiter.Allow() {
		next(w, r)
	} else {
		api.WriteResponse(w, r, nil, api.StatusLimitExceeded)
	}
}

func NewRateLimiter(eventsPerSecond int) *rateLimiter {
	return &rateLimiter{
		limiter: *rate.NewLimiter(rate.Limit(eventsPerSecond), eventsPerSecond),
	}
}
