package storage

import (
	pb "a.yandex-team.ru/yp/go/proto/hq"
	"github.com/golang/protobuf/proto"
	"testing"
)

func TestEncode_Snappy(t *testing.T) {
	codec, err := NewCodec("rw-snappy")
	if err != nil {
		t.Fatal(err)
	}
	in := &pb.Instance{
		Meta: &pb.InstanceMeta{
			Id:        "production_nanny:1082@ws25-500.search.yandex.net",
			ServiceId: "production_nanny",
		},
		Spec: &pb.InstanceSpec{
			Revision: []*pb.InstanceRevision{
				{
					Id: "production_nanny-123245843570",
				},
			},
		},
	}
	enc, err := codec.Encode(in)
	if err != nil {
		t.Fatal(err)
	}
	if enc[0] != encodingSnappy {
		t.Fatal("First encoded byte is not equal to encodingSnappy")
	}
	out := &pb.Instance{}
	err = codec.Decode(enc, out)
	if err != nil {
		t.Fatal(err)
	}

	if !proto.Equal(in, out) {
		t.Fatalf("%+v != %+v", in, out)
	}

}

func TestDecode_Protobuf(t *testing.T) {
	codec, err := NewCodec("rw-snappy")
	if err != nil {
		t.Fatal(err)
	}
	in := &pb.Instance{
		Meta: &pb.InstanceMeta{
			Id:        "production_nanny:1082@ws25-500.search.yandex.net",
			ServiceId: "production_nanny",
		},
		Spec: &pb.InstanceSpec{
			Revision: []*pb.InstanceRevision{
				{
					Id: "production_nanny-123245843570",
				},
			},
		},
	}
	enc, err := proto.Marshal(in)
	if err != nil {
		t.Fatal(err)
	}

	if enc[0] == encodingSnappy {
		t.Fatal("First encoded byte is equal to encodingSnappy")
	}

	out := &pb.Instance{}

	err = codec.Decode(enc, out)
	if err != nil {
		t.Fatal(err)
	}

	if !proto.Equal(in, out) {
		t.Fatalf("%+v != %+v", in, out)
	}

}

func TestDecode_BadData(t *testing.T) {
	codec, err := NewCodec("rw-snappy")
	if err != nil {
		t.Fatal(err)
	}
	b := []byte("BAD_DATA")
	out := &pb.Instance{}
	err = codec.Decode(b, out)
	if err == nil {
		t.Fatal("Error is not nil")
	}
}
