package etcd3

import (
	"go.etcd.io/etcd/clientv3"
	"go.etcd.io/etcd/mvcc/mvccpb"
)

type event struct {
	key       string
	value     []byte
	rev       int64
	isDeleted bool
	isCreated bool
}

func parseKV(kv *mvccpb.KeyValue) *event {
	return &event{
		key:       string(kv.Key),
		value:     kv.Value,
		rev:       kv.ModRevision,
		isDeleted: false,
		isCreated: kv.ModRevision == kv.CreateRevision,
	}
}

func parseEvent(e *clientv3.Event) *event {
	return &event{
		key:       string(e.Kv.Key),
		value:     e.Kv.Value,
		rev:       e.Kv.ModRevision,
		isDeleted: e.Type == clientv3.EventTypeDelete,
		isCreated: e.IsCreate(),
	}
}
