package storage

import "context"

type OnCreateFunc func(ctx context.Context, key string, obj Storable, out Storable) error

type OnUpdateFunc func(ctx context.Context, key string, obj Storable) error

type OnUpdateIfMatchFunc func(ctx context.Context, key string, obj Storable, version string, out Storable) error

type OnGetFunc func(ctx context.Context, key string, objPtr Storable) error

type OnGuaranteedUpdateFunc func(ctx context.Context, key string, tryUpdate UpdateFunc) error

type OnDeleteFunc func(ctx context.Context, key string, out Storable) error

type FakeStore struct {
	OnCreate           OnCreateFunc
	OnUpdate           OnUpdateFunc
	OnUpdateIfMatch    OnUpdateIfMatchFunc
	OnGet              OnGetFunc
	OnGuaranteedUpdate OnGuaranteedUpdateFunc
	OnDelete           OnDeleteFunc
}

func (f *FakeStore) Create(ctx context.Context, key string, obj Storable, out Storable) error {
	if f.OnCreate != nil {
		return f.OnCreate(ctx, key, obj, out)
	}
	panic("Not implemented")
}

func (f *FakeStore) Update(ctx context.Context, key string, obj Storable) error {
	if f.OnUpdate != nil {
		return f.OnUpdate(ctx, key, obj)
	}
	panic("Not implemented")
}

func (f *FakeStore) UpdateIfMatch(ctx context.Context, key string, obj Storable, version string, out Storable) error {
	if f.OnUpdateIfMatch != nil {
		return f.OnUpdateIfMatch(ctx, key, obj, version, out)
	}
	panic("Not implemented")
}

func (f *FakeStore) GuaranteedUpdate(ctx context.Context, key string, tryUpdate UpdateFunc) error {
	if f.OnGuaranteedUpdate != nil {
		return f.OnGuaranteedUpdate(ctx, key, tryUpdate)
	}
	panic("Not implemented")
}

func (f *FakeStore) Delete(ctx context.Context, key string, out Storable) error {
	if f.OnDelete != nil {
		return f.OnDelete(ctx, key, out)
	}
	panic("Not implemented")
}

func (f *FakeStore) Watch(ctx context.Context, key string, resourceVersion string) (WatchInterface, error) {
	return nil, nil
}

func (f *FakeStore) WatchList(ctx context.Context, resourceVersion string) (WatchInterface, error) {
	panic("Not implemented")
}

func (f *FakeStore) Get(ctx context.Context, key string, objPtr Storable) error {
	if f.OnGet != nil {
		return f.OnGet(ctx, key, objPtr)
	}
	panic("Not implemented")
}

func (f *FakeStore) List(ctx context.Context) ([]Storable, error) {
	panic("Not implemented")
}

func (f *FakeStore) Status(ctx context.Context) error {
	panic("Not implemented")
}
