package storage

import (
	pb "a.yandex-team.ru/yp/go/proto/hq"
	"github.com/golang/protobuf/proto"
	"testing"
)

const instanceTxt = `meta {
  id: "cplptii2dg7qig4j@production_orly"
  service_id: "production_orly"
  version: "55448164662"
}
spec {
  allocation {
    limit {
      name: "mem"
      scalar {
        value: 8589934592
      }
    }
    limit {
      name: "cpu"
      scalar {
        value: 4000
      }
    }
    limit {
      name: "net"
      scalar {
      }
    }
    limit {
      name: "hdd"
      scalar {
      }
    }
    request {
      name: "mem"
      scalar {
        value: 8589934592
      }
    }
    request {
      name: "cpu"
      scalar {
        value: 4000
      }
    }
    request {
      name: "net"
      scalar {
      }
    }
    request {
      name: "hdd"
      scalar {
      }
    }
    request {
      name: "io"
      scalar {
      }
    }
    port {
      name: "default"
      port: 80
      protocol: "TCP"
    }
  }
  node_name: "man2-1078.search.yandex.net"
  revision {
    id: "production_orly-1542175173018"
    container {
      name: "etcd"
      command: "python"
      command: "/opt/orly/exec_etcd"
      readiness_probe {
        handlers {
          type: TCP_SOCKET
          tcp_socket {
            port: "2379"
          }
        }
        initial_delay_seconds: 5
        min_period_seconds: 5
        max_period_seconds: 60
        period_backoff: 2
      }
      restart_policy {
        min_period_seconds: 1
        max_period_seconds: 60
        period_backoff: 2
        period_jitter_seconds: 20
      }
      lifecycle {
        pre_stop {
        }
        termination_grace_period_seconds: 10
      }
      security_context {
        run_as_user: "root"
      }
      reopen_log_action {
        handler {
        }
      }
    }
    container {
      name: "orly"
      command: "/opt/orly/server/server"
      readiness_probe {
        handlers {
          type: TCP_SOCKET
          tcp_socket {
            port: "8080"
          }
        }
        initial_delay_seconds: 5
        min_period_seconds: 5
        max_period_seconds: 60
        period_backoff: 2
      }
      restart_policy {
        min_period_seconds: 1
        max_period_seconds: 60
        period_backoff: 2
        period_jitter_seconds: 20
      }
      lifecycle {
        pre_stop {
        }
        termination_grace_period_seconds: 10
      }
      security_context {
        run_as_user: "root"
      }
      reopen_log_action {
        handler {
        }
      }
    }
    tags: "a_geo_man"
    tags: "a_dc_man"
    tags: "a_itype_rtcsmall"
    tags: "a_ctype_production"
    tags: "a_prj_orly"
    tags: "a_metaprj_rtc"
    tags: "a_tier_none"
    tags: "use_hq_spec"
    tags: "enable_hq_report"
    tags: "enable_hq_poll"
    init_containers {
      name: "install_orly"
      command: "/bin/sh"
      command: "-c"
      command: "sudo tar -C / -xzf orly.tgz"
      readiness_probe {
      }
      restart_policy {
      }
      lifecycle {
        pre_stop {
        }
      }
      security_context {
      }
    }
    init_containers {
      name: "install_etcd"
      command: "/bin/sh"
      command: "-c"
      command: "sudo mkdir /opt/etcd && sudo tar --strip-components=1 -C /opt/etcd -xzvf etcd.tgz"
      readiness_probe {
      }
      restart_policy {
      }
      lifecycle {
        pre_stop {
        }
      }
      security_context {
      }
    }
  }
  hostname: "man2-1078-1.cplptii2dg7qig4j.man.yp-c.yandex.net"
  hostname_version {
  }
}
status {
  last_heartbeat_time {
    seconds: 1548917090
  }
  ready {
    status: "True"
    last_transition_time {
      seconds: 1544281190
    }
  }
  revision {
    id: "production_orly-1542175173018"
    installed {
      status: "True"
      reason: "RevisionInstalled"
      last_transition_time {
        seconds: 1544281259
        nanos: 590007000
      }
    }
    ready {
      status: "True"
      reason: "RevisionReady"
      last_transition_time {
        seconds: 1544281486
        nanos: 584189000
      }
    }
    container {
      name: "etcd"
      ready {
        status: "True"
        reason: "CheckPortOk"
        message: "Port check OK"
        last_transition_time {
          seconds: 1544281264
          nanos: 654749000
        }
      }
      installed {
        status: "True"
        reason: "ContainerInstalled"
        last_transition_time {
          seconds: 1544281259
          nanos: 653823000
        }
      }
      restart_count: 1
      last_termination_status {
      }
    }
    container {
      name: "orly"
      ready {
        status: "True"
        reason: "CheckPortOk"
        message: "Port check OK"
        last_transition_time {
          seconds: 1544281486
          nanos: 910614000
        }
      }
      installed {
        status: "True"
        reason: "ContainerInstalled"
        last_transition_time {
          seconds: 1544281421
          nanos: 596043000
        }
      }
      restart_count: 5
      last_termination_status {
        exit_status {
          if_exited: true
          exit_status: 1
        }
        stdout_tail: "0:59,762 - main - ERROR - Failed to connect to etcd: Connect Failed\n2018-12-08 18:01:12,153 - main - INFO - Connecting to etcd...\n2018-12-08 18:01:42,156 - main - ERROR - Failed to connect to etcd: Deadline Exceeded\n2018-12-08 18:02:01,322 - main - INFO - Connecting to etcd...\n2018-12-08 18:02:31,323 - main - ERROR - Failed to connect to etcd: Deadline Exceeded\n2018-12-08 18:02:44,171 - main - INFO - Connecting to etcd...\n2018-12-08 18:03:14,172 - main - ERROR - Failed to connect to etcd: Deadline Exceeded\n"
        start_time {
          seconds: 1544281364
          nanos: 43370000
        }
        termination_time {
          seconds: 1544281394
          nanos: 186294000
        }
      }
    }
  }
}
`

func BenchmarkInstance_Marshal(b *testing.B) {
	m := &pb.Instance{}
	if err := proto.UnmarshalText(instanceTxt, m); err != nil {
		b.Fatal("Failed to unmarshal text:", err)
	}
	b.ReportAllocs()
	b.ResetTimer()
	for i := 0; i < b.N; i++ {
		_, err := proto.Marshal(m)
		if err != nil {
			b.Fatal("Failed to marshal instance:", err)
		}
	}
}

/*func BenchmarkInstance_MarshalTo(b *testing.B) {
	m := &pb.Instance{}
	if err := proto.UnmarshalText(instanceTxt, m); err != nil {
		b.Fatal("Failed to unmarshal text:", err)
	}
	buf := make([]byte, 1 * 1024 * 1024)
	b.ReportAllocs()
	b.ResetTimer()
	for i := 0; i < b.N; i++ {
		if _, err := m.MarshalTo(buf); err != nil {
			b.Fatal("Failed to marshal instance:", err)
		}
	}
}*/

func BenchmarkInstance_Unmarshal(b *testing.B) {
	m := &pb.Instance{}
	if err := proto.UnmarshalText(instanceTxt, m); err != nil {
		b.Fatal("Failed to unmarshal text:", err)
	}
	buf, err := proto.Marshal(m)
	if err != nil {
		b.Fatal("Failed to marshal canonical instance")
	}
	m.Reset()
	b.ReportAllocs()
	b.ResetTimer()
	for i := 0; i < b.N; i++ {
		if err := proto.Unmarshal(buf, m); err != nil {
			b.Fatal("Failed to unmarshal instance:", err)
		}
	}
}
