package ypclient

import "context"

type ListPodsFunc func(ctx context.Context, podSetID string) (pods []*YpPod, err error)
type FindPodFunc func(ctx context.Context, podID string, clusters ...string) (pod *YpPod, err error)
type GetClustersFunc func() []string
type SetPodLabelFunc func(ctx context.Context, cluster string, id string, key string, value []byte) error
type SelectHQSyncerPodsFunc func(ctx context.Context) (pods []*YpPod, err error)
type ListServicePodsFunc func(ctx context.Context, serviceID string) ([]*YpPod, error)

type FakeYpClient struct {
	OnListPods           ListPodsFunc
	OnFindPod            FindPodFunc
	OnGetClusters        GetClustersFunc
	OnSetPodLabel        SetPodLabelFunc
	OnSelectHQSyncerPods SelectHQSyncerPodsFunc
	OnListServicePods    ListServicePodsFunc
}

func (f *FakeYpClient) ListPods(ctx context.Context, podSetID string) (pods []*YpPod, err error) {
	if f.OnListPods != nil {
		return f.OnListPods(ctx, podSetID)
	}
	panic("OnListPods not implemented")
}

func (f *FakeYpClient) FindPod(ctx context.Context, podID string, clusters ...string) (pod *YpPod, err error) {
	if f.OnFindPod != nil {
		return f.OnFindPod(ctx, podID, clusters...)
	}
	panic("OnFindPod not implemented")
}

func (f *FakeYpClient) GetClusters() []string {
	if f.OnGetClusters != nil {
		return f.OnGetClusters()
	}
	panic("OnGetClusters not implemented")
}

func (f *FakeYpClient) SetPodLabel(ctx context.Context, cluster string, id string, key string, value []byte) error {
	if f.OnSetPodLabel != nil {
		return f.OnSetPodLabel(ctx, cluster, id, key, value)
	}
	panic("OnSetPodLabel not implemented")
}

func (f *FakeYpClient) SelectHQSyncerPods(ctx context.Context) (pods []*YpPod, err error) {
	if f.OnSelectHQSyncerPods != nil {
		return f.OnSelectHQSyncerPods(ctx)
	}
	panic("OnSelectHQSyncerPods not implemented")
}

func (f *FakeYpClient) ListServicePods(ctx context.Context, serviceID string) ([]*YpPod, error) {
	if f.OnListServicePods != nil {
		return f.OnListServicePods(ctx, serviceID)
	}
	panic("OnListServicePods not implemented")
}
